#ifndef _CV2X_APP_LYR_COMMON_H_
#define _CV2X_APP_LYR_COMMON_H_

#ifdef __cplusplus
extern "C"
{
#endif

// define start------------------------------------

/// code type
typedef enum _CodeType_ {
    BER_CODE_TYPE = 0,
    DER_CODE_TYPE,
    UPER_CODE_TYPE,
    CODE_TYPE_MAX
} eCodeType;

/// return value
typedef enum _eCv2xErrNum_ {
    CV2X_SUCCESS = 0x0000,
    ERR_CV2X_TMP = 0x0001,
    // sys err(from 0x0002)------
    ERR_CV2X_PTHREAD_CREATE = 0x0002,
    ERR_CV2X_PIPE_CREATE,
    ERR_CV2X_FOPEN, 
    ERR_CV2X_MALLOC, 
    ERR_CV2X_CALLOC, 
    // user err(from 5000)------
    ERR_CV2X_PARM_CONT = 5000,
    // decode err------
    ERR_CV2X_BER_DECODE,
    ERR_CV2X_UPER_DECODE,
    ERR_CV2X_DECODE_DATA_LESS,
    ERR_CV2X_DECODE_DATA_REQ_MORE,
    // BSM err------
    ERR_CV2X_BSM_DER_ENCODE,
    ERR_CV2X_BSM_UPER_ENCODE,
    ERR_CV2X_BSM_CODE_TYPE,
    ERR_CV2X_BSM_DECODE_TYPE,
    // MAP err------
    ERR_CV2X_MAP_DER_ENCODE,
    ERR_CV2X_MAP_UPER_ENCODE,
    ERR_CV2X_MAP_CODE_TYPE,
    ERR_CV2X_MAP_DECODE_TYPE,
    // RSI err------
    ERR_CV2X_RSI_DER_ENCODE,
    ERR_CV2X_RSI_UPER_ENCODE,
    ERR_CV2X_RSI_CODE_TYPE,
    ERR_CV2X_RSI_DECODE_TYPE,
    // RSM err------
    ERR_CV2X_RSM_DER_ENCODE,
    ERR_CV2X_RSM_UPER_ENCODE,
    ERR_CV2X_RSM_CODE_TYPE,
    ERR_CV2X_RSM_DECODE_TYPE,
    // SPAT err------
    ERR_CV2X_SPAT_DER_ENCODE,
    ERR_CV2X_SPAT_UPER_ENCODE,
    ERR_CV2X_SPAT_CODE_TYPE,
    ERR_CV2X_SPAT_DECODE_TYPE,
    //------
    ERR_CV2X_MAX
} eCv2xErrNum;

// define end--------------------------------------

// func extern start-------------------------------

// func extern end---------------------------------

#ifdef __cplusplus
}
#endif

/// Close the doxygen group
///
/// @}
///

#endif   /* end _CV2X_APP_LYR_COMMON_H_ */
