/******************************************************************************
 * Copyright 2018 The Apollo Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *****************************************************************************/

#ifndef _CV2X_MESSAGE_FRAME_H_
#define _CV2X_MESSAGE_FRAME_H_

//------
#include "asn1_source/MessageFrame.h"
//------
#include "common.h"

#ifdef __cplusplus
extern "C"
{
#endif

//define start---------------------------------------

//define end-----------------------------------------

//func extern start-------------------------------

/**
 *
 * @brief: Create MessageFrame memory.
 *
 * @param aoppMsgFme: output memory.
 *
 * @return
 * return 0 SUCCESS, others error.
 *
 */
extern 
int 
cv2x_message_frame_create(MessageFrame_t **aoppMsgFme);

/**
 *
 * @brief: Free MessageFrame memory.
 *
 * @param aipMsgFme: input free memory.
 *        aicFreFlg(must 0 or 1): If (aicFreFlg) is set, 
 *              the wrapper structure itself (struct_ptr)
 *              will not be freed.
 *
 * @return
 * return: 0 SUCCESS, others error.
 *
 */
extern 
int 
cv2x_message_frame_free(
    MessageFrame_t *aipMsgFme, 
    const int aicFreFlg);

/**
 *
 * @brief: MessageFrame encode.
 *
 * @param aipMsgFme: input MessageFrame_t.
 * @param aicCdTp: code type, such as PER or DER.
 * @param aopBuf: output encode buff.
 * @param aicBufSize: input encode buff max size.
 * @param aopcNumByteEncod: output encode bytes.
 *
 * @return
 * return 0 SUCCESS, others error.
 *
 */
extern 
int 
cv2x_message_frame_encode(
    MessageFrame_t *aipMsgFme, 
    const eCodeType aicCdTp, 
    char *aopBuf, 
    const int aicBufSize, 
    int* const aopcNumByteEncod);

/**
 *
 * @brief: MessageFrame decode.
 *
 * @param aoppMsgFme: output decode MessageFrame_t.
 * @param aicCdTp: code type, such as PER or DER.
 * @param aipBuf: input decode buff.
 * @param aicBufSize: Decode len.
 *
 * @return
 * return 0 SUCCESS, others error.
 *
 */
extern 
int 
cv2x_message_frame_decode(
    MessageFrame_t **aoppMsgFme, 
    const eCodeType aicCdTp, 
    char *aipBuf, 
    const int aicBufSize);

//func extern end---------------------------------

#ifdef __cplusplus
}
#endif

/// Close the doxygen group
///
/// @}
///

#endif   /* end _CV2X_MESSAGE_FRAME_H_ */
